#==============================================================================
#  Window_InputString
#------------------------------------------------------------------------------
# ͗pEBhE
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ

class Window_InputString < ::Window_InputString
  #--------------------------------------------------------------------------
  # J[\XvCg̎擾
  #--------------------------------------------------------------------------
  def sprite_cursor
    if @sprite_cursor.nil?
      @sprite_cursor = DQ::Sprite_Cursor.new(self.viewport)
      @sprite_cursor.z = self.z + 2
    end
    return @sprite_cursor
  end
  #--------------------------------------------------------------------------
  # J[\XvCg̈ړ
  #--------------------------------------------------------------------------
  def move_cursor_sprite
    # ڂ̍WvZ
    if @cursor_x == 15 and [0,1,2].include?(@cursor_y)
      x = 532
      y = @cursor_y * 32 + 32
      rect = Rect.new(x - 4, y, 44 + 8, 32)
    else
      x = @cursor_x * 32 + 4
      x += 16 if @cursor_x >= 5
      x += 16 if @cursor_x >= 10
      y = @cursor_y * 32 + 32
      rect = Rect.new(x, y, 32, 32)
    end

    tx = 4 + 16 / 2 - sprite_cursor.src_rect.width / 2
    ty = 16 + rect.height / 2 - sprite_cursor.src_rect.height / 2
    sprite_cursor.x = self.x + rect.x + tx
    sprite_cursor.y = self.y + rect.y + ty
  end
  #--------------------------------------------------------------------------
  # J[\XvCg̍XV
  #--------------------------------------------------------------------------
  def update_cursor_sprite
    sprite_cursor.visible = self.visible
    if self.active
      sprite_cursor.white_blink_on
    else
      sprite_cursor.white_blink_off
    end
    sprite_cursor.update
    move_cursor_sprite
  end
  #--------------------------------------------------------------------------
  # J[\̋`XV
  #--------------------------------------------------------------------------
  def update_cursor_rect
    return if self.contents.nil?

    if @sprite_cursor.nil?
      sprite_cursor.visible = false
      return
    end

    update_cursor_sprite
  end
  #--------------------------------------------------------------------------
  # EBhEƃJ[\̉Ԃ𓯊
  #--------------------------------------------------------------------------
  def visible=(arg)
    super(arg)
    sprite_cursor.visible = self.visible
  end
  #--------------------------------------------------------------------------
  # EBhE폜ɃJ[\
  #--------------------------------------------------------------------------
  def dispose
    if not @sprite_cursor.nil?
      @sprite_cursor.dispose
    end
    super
  end
end

end
